/*
 * Decompiled with CFR 0.152.
 */
package se.michaelthelin.spotify.requests;

import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.ParseException;
import se.michaelthelin.spotify.IHttpManager;
import se.michaelthelin.spotify.exceptions.SpotifyWebApiException;

public interface IRequest<T> {
    public IHttpManager getHttpManager();

    public URI getUri();

    public List<Header> getHeaders();

    public ContentType getContentType();

    public HttpEntity getBody();

    public List<NameValuePair> getBodyParameters();

    public T execute() throws IOException, SpotifyWebApiException, ParseException;

    public CompletableFuture<T> executeAsync();

    public String getJson() throws IOException, SpotifyWebApiException, ParseException;

    public String postJson() throws IOException, SpotifyWebApiException, ParseException;

    public String putJson() throws IOException, SpotifyWebApiException, ParseException;

    public String deleteJson() throws IOException, SpotifyWebApiException, ParseException;

    @JsonPOJOBuilder(withPrefix="set")
    public static interface Builder<T, BT extends Builder<T, ?>> {
        public BT setHttpManager(IHttpManager var1);

        public BT setScheme(String var1);

        public BT setHost(String var1);

        public BT setPort(Integer var1);

        public BT setPath(String var1);

        public BT setPathParameter(String var1, String var2);

        public BT setDefaults(IHttpManager var1, String var2, String var3, Integer var4);

        public <ST> BT setQueryParameter(String var1, ST var2);

        public <ST> BT setHeader(String var1, ST var2);

        public BT setContentType(ContentType var1);

        public BT setBody(HttpEntity var1);

        public <ST> BT setBodyParameter(String var1, ST var2);

        public IRequest<T> build();
    }
}

