/*
 * Decompiled with CFR 0.152.
 */
package se.michaelthelin.spotify.requests.data.personalization;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import org.apache.hc.core5.http.ParseException;
import se.michaelthelin.spotify.enums.ModelObjectType;
import se.michaelthelin.spotify.exceptions.SpotifyWebApiException;
import se.michaelthelin.spotify.model_objects.AbstractModelObject;
import se.michaelthelin.spotify.model_objects.specification.Artist;
import se.michaelthelin.spotify.model_objects.specification.Paging;
import se.michaelthelin.spotify.model_objects.specification.Track;
import se.michaelthelin.spotify.requests.data.AbstractDataPagingRequest;
import se.michaelthelin.spotify.requests.data.AbstractDataRequest;
import se.michaelthelin.spotify.requests.data.personalization.interfaces.IArtistTrackModelObject;

@JsonDeserialize(builder=Builder.class)
public class GetUsersTopArtistsAndTracksRequest<T extends IArtistTrackModelObject>
extends AbstractDataRequest<Paging<T>> {
    private final AbstractModelObject.JsonUtil<T> tClass;

    private GetUsersTopArtistsAndTracksRequest(Builder<T> builder, AbstractModelObject.JsonUtil<T> tClass) {
        super(builder);
        this.tClass = tClass;
    }

    @Override
    public Paging<T> execute() throws IOException, SpotifyWebApiException, ParseException {
        return this.tClass.createModelObjectPaging(this.getJson());
    }

    public static final class Builder<T extends IArtistTrackModelObject>
    extends AbstractDataPagingRequest.Builder<T, Builder<T>> {
        private AbstractModelObject.JsonUtil<T> tClass;

        public Builder(String accessToken) {
            super(accessToken);
        }

        public Builder<T> type(ModelObjectType type) {
            assert (type != null);
            assert (type.getType().equals("artists") || type.getType().equals("tracks"));
            switch (type.getType()) {
                case "artists": {
                    this.tClass = new Artist.JsonUtil();
                    break;
                }
                case "tracks": {
                    this.tClass = new Track.JsonUtil();
                }
            }
            return (Builder)this.setPathParameter("type", type.getType());
        }

        @Override
        public Builder<T> limit(Integer limit) {
            assert (limit != null);
            assert (1 <= limit && limit <= 50);
            return (Builder)this.setQueryParameter("limit", limit);
        }

        @Override
        public Builder<T> offset(Integer offset) {
            assert (offset >= 0);
            return (Builder)this.setQueryParameter("offset", offset);
        }

        public Builder<T> time_range(String time_range) {
            assert (time_range != null);
            assert (time_range.equals("long_term") || time_range.equals("medium_term") || time_range.equals("short_term"));
            return (Builder)this.setQueryParameter("time_range", time_range);
        }

        @Override
        public GetUsersTopArtistsAndTracksRequest<T> build() {
            this.setPath("/v1/me/top/{type}");
            return new GetUsersTopArtistsAndTracksRequest(this, this.tClass);
        }

        @Override
        protected Builder<T> self() {
            return this;
        }
    }
}

