/*
 * Decompiled with CFR 0.152.
 */
package se.michaelthelin.spotify.requests.data.player;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.IOException;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.ParseException;
import se.michaelthelin.spotify.exceptions.SpotifyWebApiException;
import se.michaelthelin.spotify.requests.data.AbstractDataRequest;

@JsonDeserialize(builder=Builder.class)
public class StartResumeUsersPlaybackRequest
extends AbstractDataRequest<String> {
    private StartResumeUsersPlaybackRequest(Builder builder) {
        super(builder);
    }

    @Override
    public String execute() throws IOException, SpotifyWebApiException, ParseException {
        return this.putJson();
    }

    public static final class Builder
    extends AbstractDataRequest.Builder<String, Builder> {
        public Builder(String accessToken) {
            super(accessToken);
        }

        public Builder device_id(String device_id) {
            assert (device_id != null);
            assert (!device_id.equals(""));
            return (Builder)this.setQueryParameter("device_id", device_id);
        }

        public Builder context_uri(String context_uri) {
            assert (context_uri != null);
            assert (!context_uri.equals(""));
            return (Builder)this.setBodyParameter("context_uri", context_uri);
        }

        public Builder uris(JsonArray uris) {
            assert (uris != null);
            assert (!uris.isJsonNull());
            return (Builder)this.setBodyParameter("uris", uris);
        }

        public Builder offset(JsonObject offset) {
            assert (offset != null);
            assert (!offset.isJsonNull());
            return (Builder)this.setBodyParameter("offset", offset);
        }

        public Builder position_ms(Integer position_ms) {
            assert (position_ms != null);
            assert (position_ms >= 0);
            return (Builder)this.setBodyParameter("position_ms", position_ms);
        }

        public StartResumeUsersPlaybackRequest build() {
            this.setContentType(ContentType.APPLICATION_JSON);
            this.setPath("/v1/me/player/play");
            return new StartResumeUsersPlaybackRequest(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

