/*
 * Decompiled with CFR 0.152.
 */
package se.michaelthelin.spotify.requests.data.playlists;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import org.apache.hc.core5.http.ParseException;
import se.michaelthelin.spotify.exceptions.SpotifyWebApiException;
import se.michaelthelin.spotify.model_objects.specification.Paging;
import se.michaelthelin.spotify.model_objects.specification.PlaylistSimplified;
import se.michaelthelin.spotify.requests.data.AbstractDataPagingRequest;
import se.michaelthelin.spotify.requests.data.AbstractDataRequest;

@JsonDeserialize(builder=Builder.class)
public class GetListOfCurrentUsersPlaylistsRequest
extends AbstractDataRequest<Paging<PlaylistSimplified>> {
    private GetListOfCurrentUsersPlaylistsRequest(Builder builder) {
        super(builder);
    }

    @Override
    public Paging<PlaylistSimplified> execute() throws IOException, SpotifyWebApiException, ParseException {
        return new PlaylistSimplified.JsonUtil().createModelObjectPaging(this.getJson());
    }

    public static final class Builder
    extends AbstractDataPagingRequest.Builder<PlaylistSimplified, Builder> {
        public Builder(String accessToken) {
            super(accessToken);
        }

        @Override
        public Builder limit(Integer limit) {
            assert (1 <= limit && limit <= 50);
            return (Builder)this.setQueryParameter("limit", limit);
        }

        @Override
        public Builder offset(Integer offset) {
            assert (0 <= offset && offset <= 100000);
            return (Builder)this.setQueryParameter("offset", offset);
        }

        public GetListOfCurrentUsersPlaylistsRequest build() {
            this.setPath("/v1/me/playlists");
            return new GetListOfCurrentUsersPlaylistsRequest(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

