/*
 * Decompiled with CFR 0.152.
 */
package se.michaelthelin.spotify.requests.data.users_profile;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import org.apache.hc.core5.http.ParseException;
import se.michaelthelin.spotify.exceptions.SpotifyWebApiException;
import se.michaelthelin.spotify.model_objects.specification.User;
import se.michaelthelin.spotify.requests.data.AbstractDataRequest;

@JsonDeserialize(builder=Builder.class)
public class GetUsersProfileRequest
extends AbstractDataRequest<User> {
    private GetUsersProfileRequest(Builder builder) {
        super(builder);
    }

    @Override
    public User execute() throws IOException, SpotifyWebApiException, ParseException {
        return (User)new User.JsonUtil().createModelObject(this.getJson());
    }

    public static final class Builder
    extends AbstractDataRequest.Builder<User, Builder> {
        public Builder(String accessToken) {
            super(accessToken);
        }

        public Builder user_id(String user_id) {
            assert (user_id != null);
            assert (!user_id.equals(""));
            return (Builder)this.setPathParameter("user_id", user_id);
        }

        public GetUsersProfileRequest build() {
            this.setPath("/v1/users/{user_id}");
            return new GetUsersProfileRequest(this);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

