/*
 * Decompiled with CFR 0.152.
 */
package org.openstatic.routeput.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Base64;
import org.openstatic.routeput.RoutePutMessage;
import org.openstatic.routeput.RoutePutMessageListener;
import org.openstatic.routeput.RoutePutSession;

public class RoutePutInputStream
extends InputStream
implements RoutePutMessageListener {
    private ByteBuffer buffer = ByteBuffer.allocate(524288);
    private boolean buffferWritten;

    public RoutePutInputStream() {
        this.buffer.clear();
        this.buffferWritten = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        while (!this.buffer.hasRemaining()) {
            try {
                this.wait();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        RoutePutInputStream routePutInputStream = this;
        synchronized (routePutInputStream) {
            byte byteToReturn = this.buffer.get();
            return byteToReturn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] b) throws IOException {
        while (!this.buffer.hasRemaining()) {
            try {
                this.wait();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        RoutePutInputStream routePutInputStream = this;
        synchronized (routePutInputStream) {
            int bytesBefore = this.buffer.remaining();
            this.buffer.get(b);
            int bytesRead = bytesBefore - this.buffer.remaining();
            return bytesRead;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        while (!this.buffer.hasRemaining()) {
            try {
                this.wait();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        RoutePutInputStream routePutInputStream = this;
        synchronized (routePutInputStream) {
            int bytesBefore = this.buffer.remaining();
            this.buffer.get(b, off, len);
            int bytesRead = bytesBefore - this.buffer.remaining();
            return bytesRead;
        }
    }

    @Override
    public int available() throws IOException {
        return this.buffer.remaining();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMessage(RoutePutSession session, RoutePutMessage message) {
        if (message.isType("binary")) {
            RoutePutInputStream routePutInputStream = this;
            synchronized (routePutInputStream) {
                byte[] data = Base64.getDecoder().decode(message.optString("data", ""));
                if (this.buffferWritten) {
                    this.buffer.compact();
                } else {
                    this.buffferWritten = true;
                }
                try {
                    this.buffer.put(data);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.buffer.flip();
                this.notify();
            }
        }
    }
}

