/*
 * Decompiled with CFR 0.152.
 */
package org.openstatic.routeput.midi;

import javax.sound.midi.MidiMessage;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import org.json.JSONArray;
import org.openstatic.routeput.RoutePutChannel;
import org.openstatic.routeput.RoutePutMessage;
import org.openstatic.routeput.RoutePutSession;

public class RouteputMIDIReceiver
implements Receiver {
    private RoutePutChannel channel;
    private RoutePutSession session;
    private int beatPulse;
    private long lastTimeStamp;
    private boolean enableTimestamps;
    private boolean opened;

    public RouteputMIDIReceiver(RoutePutSession session, RoutePutChannel channel) {
        this.channel = channel;
        this.beatPulse = 1;
        this.session = session;
        this.enableTimestamps = true;
        this.opened = true;
    }

    public void setEnableTimestamps(boolean v) {
        this.enableTimestamps = v;
    }

    public long getMicrosecondPosition() {
        return this.lastTimeStamp;
    }

    public boolean isOpened() {
        return this.session.isConnected();
    }

    public String getName() {
        return this.channel.getName();
    }

    @Override
    public void close() {
        this.opened = false;
    }

    @Override
    public void send(MidiMessage message, long timeStamp) {
        if (message instanceof ShortMessage && this.session.isConnected() && this.opened) {
            ShortMessage sm = (ShortMessage)message;
            int smStatus = sm.getStatus();
            if (smStatus == 248) {
                this.sendPulse(timeStamp);
            } else {
                this.lastTimeStamp = timeStamp;
                RoutePutMessage mm = new RoutePutMessage();
                mm.setType("midi");
                JSONArray dArray = new JSONArray();
                dArray.put(sm.getStatus());
                dArray.put(sm.getData1());
                dArray.put(sm.getData2());
                mm.setMetaField("data", dArray);
                if (timeStamp >= 0L && this.enableTimestamps) {
                    mm.setMetaField("ts", timeStamp);
                }
                mm.setChannel(this.channel);
                this.session.send(mm);
            }
        }
    }

    public void sendPulse(long timeStamp) {
        if (this.opened) {
            this.lastTimeStamp = timeStamp;
            RoutePutMessage mm = new RoutePutMessage();
            mm.setType("pulse");
            mm.setMetaField("ts", timeStamp);
            mm.setMetaField("pulse", this.beatPulse);
            if (this.beatPulse >= 24) {
                this.beatPulse = 0;
            }
            ++this.beatPulse;
            mm.setChannel(this.channel);
            this.session.send(mm);
        }
    }

    public String toString() {
        return this.getName();
    }
}

